<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Post_Level extends CI_Controller{
    
    public function __construct() {
        parent::__construct();
        $this->data['page_name'] = "Post Level";
        $this->load->model('post_level_model','pl_model');        
        $this->load->model('exam_org_model','eo_model');
        
        $this->data['exam_orgs'] = $this->eo_model->get();
    }
    
    public function index(){        
        $this->data['post_levels'] = $this->pl_model->get();
        $this->load->view('post_level/index',$this->data);
    }
    
    public function create(){
        $this->form_validation->set_rules(array(
            array(
                'field' => 'post_level',
                'label' => 'Post Level',
                'rules' => 'required',
                'errors' => array(
                        'required' => '%s cannot be left blank.',
                )
            ),
            array(
                'field' => 'exam_org_ID',
                'label' => 'Exam Organization',
                'rules' => 'required',
                'errors' => array(
                        'required' => 'Please select an %s.',
                )
            )
       ));
        if($this->form_validation->run() === true){
            if($this->pl_model->insert()){
                set_alert('success' ,'New Post Level Created Successfully.' );
                redirect('post_level','refresh');
            } else {
                set_alert('error' , 'Error While Creating Post Level.');
            }
        }
        $this->load->view('post_level/create',$this->data);
    }
    
    public function edit(){
        $this->data['post_levels'] = $this->pl_model->get($this->input->post('edit_id'));
        $this->load->view('post_level/edit',$this->data);
    }
    
    public function update(){
        if($this->pl_model->update()){
           set_alert('success' ,'Post Level Updated Successfully.' );
           redirect('post_level','refresh');
       } else {
           set_alert('error' , 'Error While Updating Post Level.');
       } 
    }
    
    public function delete(){
        
        if( $this->pl_model->delete($this->input->post('delete_id')) ){
            set_alert('success','Post Level deleted successfully.');
        } else {
            set_alert('error','Error while deleting Post Level.');
        }             
        redirect('post_level');
    }
    
}

